/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class OpenTTY
extends MIDlet
implements CommandListener {
    boolean app;
    int currentIndex = 0;
    String path = "/";
    String username = "";
    String version = "1.6.1";
    String xversion = "0.4";
    String hostname = "unknown";
    String tty = "/java/optty1";
    RecordStore userStore = null;
    Hashtable paths = new Hashtable();
    Hashtable aliases = new Hashtable();
    Vector commandHistory = new Vector();
    Hashtable attributes = new Hashtable();
    String nanoContent = OpenTTY.loadRMS$(this, "nano", 1);
    Display display = Display.getDisplay((MIDlet)this);
    Form form = new Form("OpenTTY ".concat(String.valueOf(this.version)));
    Command enterCommand = new Command("Send", 4, 1);
    Command helpCommand = new Command("Help", 1, 2);
    Command nanoCommand = new Command("Nano", 1, 3);
    Command clearCommand = new Command("Clear", 1, 4);
    Command historyCommand = new Command("History", 1, 5);
    TextField commandInput = new TextField("Command", "", 256, 0);
    StringItem output = new StringItem("", "Welcome to OpenTTY ".concat(String.valueOf(this.version)).concat("\nCopyright (C) 2024 - Mr. Lima\n"));

    public void startApp() throws  {
        if (!this.app) {
            OpenTTY.loadUsername$(this);
            OpenTTY.mount$(this);
            this.commandInput.setLabel(String.valueOf(this.username) + " " + String.valueOf(this.path) + " $");
            this.attributes.put("PATCH", "FS Update");
            this.attributes.put("VERSION", this.version);
            this.attributes.put("TYPE", System.getProperty("microedition.platform"));
            this.attributes.put("TYPE", System.getProperty("microedition.platform"));
            this.attributes.put("CONFIG", System.getProperty("microedition.configuration"));
            this.attributes.put("PROFILE", System.getProperty("microedition.profiles"));
            this.form.append((Item)this.output);
            this.form.append((Item)this.commandInput);
            this.form.addCommand(this.enterCommand);
            this.form.addCommand(this.helpCommand);
            this.form.addCommand(this.nanoCommand);
            this.form.addCommand(this.clearCommand);
            this.form.addCommand(this.historyCommand);
            this.form.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.form);
        }
    }

    public void pauseApp() throws  {
        this.app = true;
    }

    public void destroyApp(boolean bl) throws  {
        OpenTTY.writeRMS$(this, "nano", this.nanoContent);
    }

    public void commandAction(Command command, Displayable displayable) throws  {
        if (command == this.enterCommand) {
            String string = this.commandInput.getString();
            if (!string.equals("")) {
                this.commandHistory.addElement(this.commandInput.getString());
            }
            OpenTTY.processCommand$(this, string);
            this.commandInput.setLabel(String.valueOf(this.username) + " " + String.valueOf(this.path) + " $");
            this.attributes.put("PATH", this.path);
            this.commandInput.setString("");
        } else if (command == this.clearCommand) {
            this.output.setText("");
        } else if (command == this.helpCommand) {
            OpenTTY.processCommand$(this, "help");
        } else if (command == this.historyCommand) {
            OpenTTY.showHistory$(this);
        } else if (command == this.nanoCommand) {
            OpenTTY.nano$(this);
        }
    }

    static void processCommand$(OpenTTY openTTY, String string) throws  {
        string = OpenTTY.env$(openTTY, string.trim());
        String string2 = OpenTTY.getCommand$(openTTY, string).toLowerCase();
        String string3 = OpenTTY.getArgument$(openTTY, string);
        if (openTTY.aliases.containsKey(string2)) {
            string2 = (String)openTTY.aliases.get(string2);
        }
        if (!string2.equals("")) {
            if (string2.equals("!")) {
                OpenTTY.echoCommand$(openTTY, "OpenTTY Java Edition");
            } else if (string2.equals("nano")) {
                OpenTTY.nano$(openTTY);
            } else if (string2.equals("netstat")) {
                OpenTTY.netstat$(openTTY);
            } else if (string2.equals("date")) {
                OpenTTY.dateCommand$(openTTY);
            } else if (string2.equals("lock")) {
                OpenTTY.lockCommand$(openTTY);
            } else if (string2.equals("htop")) {
                OpenTTY.htopCommand$(openTTY);
            } else if (string2.equals("tty")) {
                OpenTTY.echoCommand$(openTTY, openTTY.tty);
            } else if (string2.equals("history")) {
                OpenTTY.showHistory$(openTTY);
            } else if (string2.equals("pwd")) {
                OpenTTY.echoCommand$(openTTY, openTTY.path);
            } else if (string2.equals("login")) {
                OpenTTY.login$(openTTY, string3);
            } else if (string2.equals("if")) {
                OpenTTY.ifCommand$(openTTY, string3);
            } else if (string2.equals("rnano")) {
                openTTY.nanoContent = "";
            } else if (string2.equals("fw")) {
                OpenTTY.fwCommand$(openTTY, string3);
            } else if (string2.equals("cd")) {
                OpenTTY.changeDisk$(openTTY, string3);
            } else if (string2.equals("ipconfig")) {
                OpenTTY.fwCommand$(openTTY, "ip");
            } else if (string2.equals("set")) {
                OpenTTY.setCommand$(openTTY, string3);
            } else if (string2.equals("install")) {
                OpenTTY.install$(openTTY, string3);
            } else if (string2.equals("load")) {
                OpenTTY.loadCommand$(openTTY, string3);
            } else if (string2.equals("run")) {
                OpenTTY.runScript$(openTTY, openTTY.nanoContent);
            } else if (string2.equals("ping")) {
                OpenTTY.pingCommand$(openTTY, string3);
            } else if (string2.equals("curl")) {
                OpenTTY.curlCommand$(openTTY, string3);
            } else if (string2.equals("wget")) {
                OpenTTY.wgetCommand$(openTTY, string3);
            } else if (string2.equals("call")) {
                OpenTTY.callCommand$(openTTY, string3);
            } else if (string2.equals("echo")) {
                OpenTTY.echoCommand$(openTTY, string3);
            } else if (string2.equals("open")) {
                OpenTTY.openCommand$(openTTY, string3);
            } else if (string2.equals("unset")) {
                OpenTTY.unsetCommand$(openTTY, string3);
            } else if (string2.equals("uname")) {
                OpenTTY.unameCommand$(openTTY, string3);
            } else if (string2.equals("alias")) {
                OpenTTY.aliasCommand$(openTTY, string3);
            } else if (string2.equals("raw")) {
                OpenTTY.echoCommand$(openTTY, openTTY.nanoContent);
            } else if (string2.equals("hostname")) {
                OpenTTY.echoCommand$(openTTY, openTTY.hostname);
            } else if (string2.equals("rraw")) {
                openTTY.output.setText(openTTY.nanoContent);
            } else if (string2.equals("unalias")) {
                OpenTTY.unaliasCommand$(openTTY, string3);
            } else if (string2.equals("execute")) {
                OpenTTY.processCommand$(openTTY, string3);
            } else if (!string2.equals("true") && !string2.equals("false")) {
                if (string2.equals("forget")) {
                    openTTY.commandHistory = new Vector();
                } else if (string2.equals("getty")) {
                    openTTY.nanoContent = openTTY.output.getText();
                } else if (string2.equals("json")) {
                    OpenTTY.echoCommand$(openTTY, OpenTTY.parseJson$(openTTY, openTTY.nanoContent));
                } else if (string2.equals("version")) {
                    OpenTTY.echoCommand$(openTTY, "OpenTTY ".concat(String.valueOf(openTTY.version)));
                } else if (string2.equals("debug")) {
                    OpenTTY.runScript$(openTTY, OpenTTY.read$(openTTY, "/scripts/debug.sh"));
                } else if (string2.equals("warn")) {
                    OpenTTY.warnCommand$(openTTY, "OpenTTY ".concat(String.valueOf(openTTY.version)), string3);
                } else if (string2.equals("html")) {
                    OpenTTY.viewer$(openTTY, "HTML Viewer", OpenTTY.html2text$(openTTY, openTTY.nanoContent));
                } else if (string2.equals("help")) {
                    OpenTTY.viewer$(openTTY, "OpenTTY Help", OpenTTY.read$(openTTY, "/java/help.txt"));
                } else if (string2.equals("ls")) {
                    OpenTTY.viewer$(openTTY, "Resources", OpenTTY.read$(openTTY, "/java/resources.txt"));
                } else if (string2.equals("exit")) {
                    OpenTTY.writeRMS$(openTTY, "nano", openTTY.nanoContent);
                    openTTY.notifyDestroyed();
                } else if (string2.equals("clear") || string2.equals("cls")) {
                    openTTY.output.setText("");
                } else if (string2.equals("ttysize")) {
                    OpenTTY.echoCommand$(openTTY, String.valueOf(openTTY.output.getText().length()).concat(" KB"));
                } else if (string2.equals("locale")) {
                    OpenTTY.echoCommand$(openTTY, System.getProperty("microedition.locale"));
                } else if (string2.equals(".")) {
                    if (string3.equals("")) {
                        OpenTTY.echoCommand$(openTTY, ". /<file>.sh");
                    } else {
                        OpenTTY.runScript$(openTTY, OpenTTY.read$(openTTY, string3));
                    }
                } else if (string2.equals("cat")) {
                    if (string3.equals("")) {
                        OpenTTY.echoCommand$(openTTY, "Usage: cat <file>");
                    } else {
                        OpenTTY.echoCommand$(openTTY, OpenTTY.read$(openTTY, string3));
                    }
                } else if (string2.equals("get")) {
                    if (string3.equals("")) {
                        OpenTTY.echoCommand$(openTTY, "Usage: get <file>");
                    } else {
                        openTTY.nanoContent = OpenTTY.read$(openTTY, string3);
                    }
                } else if (string2.equals("title")) {
                    if (string3.equals("")) {
                        openTTY.form.setTitle("OpenTTY ".concat(String.valueOf(openTTY.version)));
                    } else {
                        openTTY.form.setTitle(string3);
                    }
                } else if (string2.equals("whoami")) {
                    if (openTTY.username.equals("")) {
                        OpenTTY.echoCommand$(openTTY, "whoami: not logged");
                    } else {
                        OpenTTY.echoCommand$(openTTY, String.valueOf(openTTY.username).concat("@").concat(String.valueOf(openTTY.hostname)));
                    }
                } else if (string2.equals("logout")) {
                    if (openTTY.username.equals("")) {
                        OpenTTY.echoCommand$(openTTY, "logout: not logged");
                    } else {
                        OpenTTY.echoCommand$(openTTY, "[ OpenTTY ] logout disabled");
                        OpenTTY.processCommand$(openTTY, "warn You cant charge your username! Read more at Github project Wiki. ");
                    }
                } else if (string2.equals("xorg")) {
                    if (string3.length() == 0 || string3.equals("help")) {
                        OpenTTY.viewer$(openTTY, "OpenTTY X.Org", "OpenTTY X.Org - X Server " + String.valueOf(openTTY.xversion) + "\nRelease Date: 2024-07-25\nX Protocol Version 1, Revision 3\nBuild OS: " + String.valueOf(System.getProperty("microedition.platform")));
                    } else if (string3.equals("stop")) {
                        openTTY.display.setCurrent((Displayable)new Form(""));
                    }
                } else if (string2.equals("sh")) {
                    openTTY.form.setTitle("OpenTTY ".concat(String.valueOf(openTTY.version)));
                    openTTY.output.setText("Welcome to OpenTTY ".concat(String.valueOf(openTTY.version)).concat("\nCopyright (C) 2024 - Mr. Lima\n"));
                    openTTY.path = "/";
                } else {
                    OpenTTY.echoCommand$(openTTY, String.valueOf(string2).concat(": unknown command"));
                }
            }
        }
    }

    static String getCommand$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    static String getArgument$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1).trim();
    }

    static String html2text$(OpenTTY openTTY, String string) throws  {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                bl = true;
            } else if (c == '>') {
                bl = false;
            } else if (!bl) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static String parseJson$(OpenTTY openTTY, String string) throws  {
        Hashtable hashtable = OpenTTY.parseProperties$(openTTY, string);
        Enumeration enumeration = hashtable.keys();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            stringBuffer.append("\"").append(string2).append("\":");
            stringBuffer.append("\"").append(string3).append("\"");
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    static String loadRMS$(OpenTTY openTTY, String string, int n) throws  {
        RecordStore recordStore = null;
        String string2 = "";
        try {
            try {
                byte[] byArray;
                recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
                if (recordStore.getNumRecords() >= n && (byArray = recordStore.getRecord(n)) != null) {
                    string2 = new String(byArray);
                }
            }
            catch (RecordStoreException recordStoreException) {
                string2 = "";
            }
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreException recordStoreException) {}
            }
        }
        return string2;
    }

    static String read$(OpenTTY openTTY, String string) throws  {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            InputStream inputStream = ((Object)((Object)openTTY)).getClass().getResourceAsStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            while ((n = inputStreamReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            inputStreamReader.close();
            return OpenTTY.env$(openTTY, stringBuffer.toString());
        }
        catch (IOException iOException) {
            return iOException.getMessage();
        }
    }

    static String replace$(OpenTTY openTTY, String string, String string2, String string3) throws  {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    static String env$(OpenTTY openTTY, String string) throws  {
        Enumeration enumeration = openTTY.attributes.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)openTTY.attributes.get(string2);
            string = OpenTTY.replace$(openTTY, string, "$".concat(String.valueOf(string2)), string3);
        }
        string = OpenTTY.replace$(openTTY, string, "$PATH", openTTY.path);
        string = OpenTTY.replace$(openTTY, string, "$USERNAME", openTTY.username);
        return string;
    }

    static String[] splitLines$(OpenTTY openTTY, String string) throws  {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                vector.addElement(string.substring(n, n2));
                n = n2 + 1;
            }
            ++n2;
        }
        if (n < string.length()) {
            vector.addElement(string.substring(n));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static Hashtable parseProperties$(OpenTTY openTTY, String string) throws  {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = OpenTTY.splitLines$(openTTY, string);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            int n2 = string2.indexOf(61);
            if (n2 > 0 && n2 < string2.length() - 1) {
                String string3 = string2.substring(0, n2).trim();
                String string4 = string2.substring(n2 + 1).trim();
                hashtable.put(string3, string4);
            }
            ++n;
        }
        return hashtable;
    }

    static void aliasCommand$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            OpenTTY.echoCommand$(openTTY, "Usage: alias <name> <command>");
            return;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        openTTY.aliases.put(string2, string3);
    }

    static void unaliasCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: unalias <alias>");
            return;
        }
        if (openTTY.aliases.containsKey(string)) {
            openTTY.aliases.remove(string);
        } else {
            OpenTTY.echoCommand$(openTTY, "unalias: ".concat(String.valueOf(string)).concat(": not found"));
        }
    }

    static void setCommand$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            OpenTTY.echoCommand$(openTTY, "Usage: set <name> <value>");
            return;
        }
        openTTY.attributes.put(string.substring(0, n).trim(), string.substring(n + 1).trim());
    }

    static void unsetCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: unset <key>");
            return;
        }
        if (openTTY.attributes.containsKey(string)) {
            openTTY.attributes.remove(string);
        } else {
            OpenTTY.echoCommand$(openTTY, "unalias: ".concat(String.valueOf(string)).concat(": not found"));
        }
    }

    static void dateCommand$(OpenTTY openTTY) throws  {
        OpenTTY.echoCommand$(openTTY, ((Object)new Date()).toString());
    }

    static void unameCommand$(OpenTTY openTTY, String string) throws  {
        OpenTTY.echoCommand$(openTTY, OpenTTY.env$(openTTY, "$TYPE $CONFIG $PROFILE"));
    }

    static void echoCommand$(OpenTTY openTTY, String string) throws  {
        openTTY.output.setText(String.valueOf(openTTY.output.getText()).concat("\n").concat(String.valueOf(string)));
    }

    static void callCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: call <phone>");
            return;
        }
        try {
            openTTY.platformRequest("tel:".concat(String.valueOf(string)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void openCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: open <url>");
            return;
        }
        try {
            openTTY.platformRequest(string);
        }
        catch (Exception exception) {
            OpenTTY.echoCommand$(openTTY, "open: ".concat(String.valueOf(string)).concat(": not found"));
        }
    }

    static void warnCommand$(OpenTTY openTTY, String string, String string2) throws  {
        if (string2 == null || string2.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: warn <message>");
            return;
        }
        Alert alert = new Alert(string, string2, null, AlertType.WARNING);
        alert.setTimeout(-2);
        openTTY.display.setCurrent(alert, (Displayable)openTTY.form);
    }

    static void lockCommand$(OpenTTY openTTY) throws  {
        if (openTTY.username == null || openTTY.username.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "lock: not logged");
            return;
        }
        Form form = new Form("OpenTTY ".concat(String.valueOf(openTTY.version)).concat(" - Locked"));
        TextField textField = new TextField("Username", "", 256, 0);
        StringItem stringItem = new StringItem("", "OpenTTY was blocked! Insert your\nusername to return to console.");
        Command command = new Command("Unlock", 4, 1);
        form.append((Item)stringItem);
        form.append((Item)textField);
        form.addCommand(command);
        form.setCommandListener((CommandListener)new OpenTTY$1(openTTY, command, form, textField));
        openTTY.display.setCurrent((Displayable)form);
    }

    static void htopCommand$(OpenTTY openTTY) throws  {
        Runtime runtime = Runtime.getRuntime();
        OpenTTY.echoCommand$(openTTY, "Memory Status:\n\nUsed Memory: ".concat(String.valueOf((runtime.totalMemory() - runtime.freeMemory()) / (long)1024)).concat(" KB"));
        OpenTTY.echoCommand$(openTTY, "Free Memory: ".concat(String.valueOf(runtime.freeMemory() / (long)1024)).concat(" KB"));
        OpenTTY.echoCommand$(openTTY, "Total Memory: ".concat(String.valueOf(runtime.totalMemory() / (long)1024)).concat(" KB"));
    }

    static void showHistory$(OpenTTY openTTY) throws  {
        List list = new List("OpenTTY History", 3);
        Command command = new Command("Back", 2, 1);
        Command command2 = new Command("Run", 4, 2);
        int n = 0;
        while (n < openTTY.commandHistory.size()) {
            list.append((String)openTTY.commandHistory.elementAt(n), null);
            ++n;
        }
        list.addCommand(command);
        list.addCommand(command2);
        list.setCommandListener((CommandListener)new OpenTTY$2(openTTY, command, command2, list));
        openTTY.display.setCurrent((Displayable)list);
    }

    static void nano$(OpenTTY openTTY) throws  {
        TextBox textBox = new TextBox("Nano", openTTY.nanoContent, 4096, 0);
        Command command = new Command("Back", 4, 1);
        Command command2 = new Command("Clear", 1, 2);
        Command command3 = new Command("View as HTML", 1, 3);
        textBox.addCommand(command);
        textBox.addCommand(command2);
        textBox.addCommand(command3);
        textBox.setCommandListener((CommandListener)new OpenTTY$3(openTTY, command, command3, textBox, command2));
        openTTY.display.setCurrent((Displayable)textBox);
    }

    static void viewer$(OpenTTY openTTY, String string, String string2) throws  {
        Form form = new Form(string);
        StringItem stringItem = new StringItem(null, string2);
        Command command = new Command("Back", 4, 1);
        form.addCommand(command);
        form.append((Item)stringItem);
        form.setCommandListener((CommandListener)new OpenTTY$4(openTTY, command));
        openTTY.display.setCurrent((Displayable)form);
    }

    static void runScript$(OpenTTY openTTY, String string) throws  {
        String[] stringArray = OpenTTY.splitLines$(openTTY, OpenTTY.env$(openTTY, string));
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n].trim();
            if (!string2.startsWith("#")) {
                OpenTTY.processCommand$(openTTY, string2);
            }
            ++n;
        }
    }

    static void mount$(OpenTTY openTTY) throws  {
        openTTY.paths.put("/", new String[]{"java", "scripts"});
        openTTY.paths.put("/java", new String[]{"bin", "sounds", ".."});
        openTTY.paths.put("/java/bin", new String[]{".."});
        openTTY.paths.put("/java/sounds", new String[]{".."});
        openTTY.paths.put("/scripts", new String[]{".."});
    }

    static void changeDisk$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: cd <dir>");
            return;
        }
        String[] stringArray = (String[])openTTY.paths.get(openTTY.path);
        if (stringArray != null) {
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                openTTY.path = string.equals("..") ? ((n = openTTY.path.lastIndexOf(47)) == 0 ? "/" : openTTY.path.substring(0, n)) : (openTTY.path.equals("/") ? "/".concat(String.valueOf(string)) : String.valueOf(openTTY.path).concat("/").concat(String.valueOf(string)));
            } else {
                if (string.equals("/") || string.equals(".") || string.equals("..")) {
                    openTTY.path = "/";
                    return;
                }
                OpenTTY.echoCommand$(openTTY, "cd: ".concat(String.valueOf(string)).concat(": not found"));
            }
        } else {
            OpenTTY.echoCommand$(openTTY, "cd: ".concat(String.valueOf(string)).concat(": not found"));
        }
    }

    static void ifCommand$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        int n2 = string.indexOf(32, n + 1);
        if (n == -1) {
            OpenTTY.echoCommand$(openTTY, "Usage: if <x> <y> [command] ");
            return;
        }
        if (n2 == -1) {
            OpenTTY.processCommand$(openTTY, "warn java.io.IOException: missing operators");
            return;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1, n2).trim();
        String string4 = string.substring(n2 + 1).trim();
        if (string2.equals(string3)) {
            OpenTTY.processCommand$(openTTY, string4);
        }
    }

    static void writeRMS$(OpenTTY openTTY, String string, String string2) throws  {
        block11: {
            RecordStore recordStore = null;
            try {
                try {
                    recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
                    byte[] byArray = string2.getBytes();
                    if (recordStore.getNumRecords() > 0) {
                        recordStore.setRecord(1, byArray, 0, byArray.length);
                        break block11;
                    }
                    recordStore.addRecord(byArray, 0, byArray.length);
                }
                catch (RecordStoreException recordStoreException) {}
            }
            finally {
                if (recordStore != null) {
                    try {
                        recordStore.closeRecordStore();
                    }
                    catch (RecordStoreException recordStoreException) {}
                }
            }
        }
    }

    static void install$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            Form form = new Form("OpenTTY Install");
            TextField textField = new TextField("Filename", "", 16, 0);
            Command command = new Command("Save", 4, 1);
            form.append((Item)textField);
            form.addCommand(command);
            form.setCommandListener((CommandListener)new OpenTTY$5(openTTY, textField, command));
            openTTY.display.setCurrent((Displayable)form);
        } else {
            OpenTTY.writeRMS$(openTTY, string, openTTY.nanoContent);
        }
    }

    static void loadCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            Form form = new Form("OpenTTY Load");
            TextField textField = new TextField("Filename", "", 16, 0);
            Command command = new Command("Load", 4, 1);
            form.append((Item)textField);
            form.addCommand(command);
            form.setCommandListener((CommandListener)new OpenTTY$6(openTTY, textField, command));
            openTTY.display.setCurrent((Displayable)form);
        } else {
            openTTY.nanoContent = OpenTTY.loadRMS$(openTTY, string, 1);
        }
    }

    static void login$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: login <user>");
        } else if (openTTY.username.equals("")) {
            openTTY.username = string;
            OpenTTY.saveUsername$(openTTY, string);
        } else {
            OpenTTY.echoCommand$(openTTY, "login: already logged");
        }
    }

    static void saveUsername$(OpenTTY openTTY, String string) throws  {
        try {
            openTTY.userStore = RecordStore.openRecordStore((String)"OpenRMS", (boolean)true);
            byte[] byArray = string.getBytes();
            if (openTTY.userStore.getNumRecords() > 0) {
                openTTY.userStore.setRecord(1, byArray, 0, byArray.length);
            } else {
                openTTY.userStore.addRecord(byArray, 0, byArray.length);
            }
            openTTY.userStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    static void loadUsername$(OpenTTY openTTY) throws  {
        try {
            openTTY.userStore = RecordStore.openRecordStore((String)"OpenRMS", (boolean)true);
            if (openTTY.userStore.getNumRecords() > 0) {
                byte[] byArray = openTTY.userStore.getRecord(1);
                openTTY.username = new String(byArray);
            }
            openTTY.userStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            openTTY.username = "";
        }
    }

    static void netstat$(OpenTTY openTTY) throws  {
        new Thread(new OpenTTY$7(openTTY)).start();
    }

    static void fwCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            string = "json";
        }
        String string2 = "http://ipinfo.io/".concat(String.valueOf(string));
        new Thread(new OpenTTY$8(openTTY, string2)).start();
    }

    static void curlCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: curl <url>");
            return;
        }
        if (!string.startsWith("http://") && !string.startsWith("https://")) {
            string = "http://".concat(String.valueOf(string));
        }
        new Thread(new OpenTTY$9(openTTY, string)).start();
    }

    static void wgetCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: wget <url>");
            return;
        }
        if (!string.startsWith("http://") && !string.startsWith("https://")) {
            string = "http://".concat(String.valueOf(string));
        }
        new Thread(new OpenTTY$10(openTTY, string)).start();
    }

    static void pingCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: ping <url>");
            return;
        }
        if (!string.startsWith("http://") && !string.startsWith("https://")) {
            string = "http://".concat(String.valueOf(string));
        }
        new Thread(new OpenTTY$11(openTTY, string)).start();
    }
}

