/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class OpenTTY
extends MIDlet
implements CommandListener {
    boolean app;
    String version = "1.4";
    String username = "";
    String nanoContent = "";
    String hostname = "unknown";
    String tty = "/java/optty1";
    RecordStore userStore = null;
    Hashtable aliases = new Hashtable();
    Display display = Display.getDisplay((MIDlet)this);
    Form form = new Form("OpenTTY ".concat(String.valueOf(this.version)));
    Command enterCommand = new Command("Send", 4, 1);
    Command helpCommand = new Command("Help", 1, 2);
    Command nanoCommand = new Command("Nano", 1, 3);
    Command clearCommand = new Command("Clear", 1, 4);
    TextField commandInput = new TextField("Command", "", 256, 0);
    StringItem output = new StringItem("", "Welcome to OpenTTY ".concat(String.valueOf(this.version)).concat("\nCopyright (C) 2024 - Mr. Lima\n"));

    public void startApp() throws  {
        if (!this.app) {
            OpenTTY.loadUsername$(this);
            this.form.append((Item)this.output);
            this.form.append((Item)this.commandInput);
            this.form.addCommand(this.enterCommand);
            this.form.addCommand(this.helpCommand);
            this.form.addCommand(this.nanoCommand);
            this.form.addCommand(this.clearCommand);
            this.form.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.form);
        }
    }

    public void pauseApp() throws  {
        this.app = true;
    }

    public void destroyApp(boolean bl) throws  {
    }

    public void commandAction(Command command, Displayable displayable) throws  {
        if (command == this.enterCommand) {
            OpenTTY.processCommand$(this, this.commandInput.getString());
            this.commandInput.setString("");
        } else if (command == this.clearCommand) {
            this.output.setText("");
        } else if (command == this.helpCommand) {
            OpenTTY.processCommand$(this, "help");
        } else if (command == this.nanoCommand) {
            OpenTTY.nano$(this);
        }
    }

    static void processCommand$(OpenTTY openTTY, String string) throws  {
        string = string.trim();
        String string2 = OpenTTY.getCommand$(openTTY, string).toLowerCase();
        String string3 = OpenTTY.getArgument$(openTTY, string);
        if (openTTY.aliases.containsKey(string2)) {
            string2 = (String)openTTY.aliases.get(string2);
        }
        if (!string2.equals("")) {
            if (string2.equals("!")) {
                OpenTTY.echoCommand$(openTTY, "OpenTTY Java Edition");
            } else if (string2.equals("nano")) {
                OpenTTY.nano$(openTTY);
            } else if (string2.equals("netstat")) {
                OpenTTY.netstat$(openTTY);
            } else if (string2.equals("date")) {
                OpenTTY.dateCommand$(openTTY);
            } else if (string2.equals("lock")) {
                OpenTTY.lockCommand$(openTTY);
            } else if (string2.equals("htop")) {
                OpenTTY.htopCommand$(openTTY);
            } else if (string2.equals("tty")) {
                OpenTTY.echoCommand$(openTTY, openTTY.tty);
            } else if (string2.equals("login")) {
                OpenTTY.login$(openTTY, string3);
            } else if (string2.equals("exit")) {
                openTTY.notifyDestroyed();
            } else if (string2.equals("rnano")) {
                openTTY.nanoContent = "";
            } else if (string2.equals("run")) {
                OpenTTY.runScript$(openTTY, openTTY.nanoContent);
            } else if (string2.equals("ping")) {
                OpenTTY.pingCommand$(openTTY, string3);
            } else if (string2.equals("curl")) {
                OpenTTY.curlCommand$(openTTY, string3);
            } else if (string2.equals("wget")) {
                OpenTTY.wgetCommand$(openTTY, string3);
            } else if (string2.equals("call")) {
                OpenTTY.callCommand$(openTTY, string3);
            } else if (string2.equals("echo")) {
                OpenTTY.echoCommand$(openTTY, string3);
            } else if (string2.equals("open")) {
                OpenTTY.openCommand$(openTTY, string3);
            } else if (string2.equals("uname")) {
                OpenTTY.unameCommand$(openTTY, string3);
            } else if (string2.equals("alias")) {
                OpenTTY.aliasCommand$(openTTY, string3);
            } else if (string2.equals("raw")) {
                OpenTTY.echoCommand$(openTTY, openTTY.nanoContent);
            } else if (string2.equals("hostname")) {
                OpenTTY.echoCommand$(openTTY, openTTY.hostname);
            } else if (string2.equals("unalias")) {
                OpenTTY.unaliasCommand$(openTTY, string3);
            } else if (string2.equals("execute")) {
                OpenTTY.processCommand$(openTTY, string3);
            } else if (string2.equals("asset")) {
                OpenTTY.echoCommand$(openTTY, OpenTTY.read$(openTTY, string3));
            } else if (!string2.equals("true") && !string2.equals("false")) {
                if (string2.equals("version")) {
                    OpenTTY.echoCommand$(openTTY, "OpenTTY ".concat(String.valueOf(openTTY.version)));
                } else if (string2.equals("debug")) {
                    OpenTTY.runScript$(openTTY, OpenTTY.read$(openTTY, "/scripts/debug.sh"));
                } else if (string2.equals("ls")) {
                    OpenTTY.viewer$(openTTY, "Resources", OpenTTY.read$(openTTY, "/resources.txt"));
                } else if (string2.equals("help")) {
                    OpenTTY.viewer$(openTTY, "OpenTTY Help", OpenTTY.read$(openTTY, "/help.txt"));
                } else if (string2.equals("warn")) {
                    OpenTTY.warnCommand$(openTTY, "OpenTTY ".concat(String.valueOf(openTTY.version)), string3);
                } else if (string2.equals("html")) {
                    OpenTTY.viewer$(openTTY, "HTML Viewer", OpenTTY.html2text$(openTTY, openTTY.nanoContent));
                } else if (string2.equals("ipconfig")) {
                    OpenTTY.curlCommand$(openTTY, "http://checkip.amazonaws.com");
                } else if (string2.equals("clear") || string2.equals("cls")) {
                    openTTY.output.setText("");
                } else if (string2.equals("locale")) {
                    OpenTTY.echoCommand$(openTTY, System.getProperty("microedition.locale"));
                } else if (string2.equals("title")) {
                    if (string3.equals("")) {
                        openTTY.form.setTitle("OpenTTY ".concat(String.valueOf(openTTY.version)));
                    } else {
                        openTTY.form.setTitle(string3);
                    }
                } else if (string2.equals("whoami")) {
                    if (openTTY.username.equals("")) {
                        OpenTTY.echoCommand$(openTTY, "whoami: not logged");
                    } else {
                        OpenTTY.echoCommand$(openTTY, String.valueOf(openTTY.username).concat("@").concat(String.valueOf(openTTY.hostname)));
                    }
                } else if (string2.equals("logout")) {
                    if (openTTY.username.equals("")) {
                        OpenTTY.echoCommand$(openTTY, "logout: not logged");
                    } else {
                        OpenTTY.echoCommand$(openTTY, "[ OpenTTY ] logout disabled");
                        OpenTTY.processCommand$(openTTY, "warn Command 'logout' was disabled");
                    }
                } else if (string2.equals("sh")) {
                    openTTY.form.setTitle("OpenTTY ".concat(String.valueOf(openTTY.version)));
                    openTTY.output.setText("Welcome to OpenTTY ".concat(String.valueOf(openTTY.version)).concat("\nCopyright (C) 2024 - Mr. Lima\n"));
                } else {
                    OpenTTY.echoCommand$(openTTY, String.valueOf(string2).concat(": unknown command"));
                }
            }
        }
    }

    static String getCommand$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    static String getArgument$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1).trim();
    }

    static String html2text$(OpenTTY openTTY, String string) throws  {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                bl = true;
            } else if (c == '>') {
                bl = false;
            } else if (!bl) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static String read$(OpenTTY openTTY, String string) throws  {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            InputStream inputStream = ((Object)((Object)openTTY)).getClass().getResourceAsStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            while ((n = inputStreamReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            inputStreamReader.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return iOException.getMessage();
        }
    }

    static String[] splitLines$(OpenTTY openTTY, String string) throws  {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                vector.addElement(string.substring(n, n2));
                n = n2 + 1;
            }
            ++n2;
        }
        if (n < string.length()) {
            vector.addElement(string.substring(n));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static void aliasCommand$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            OpenTTY.echoCommand$(openTTY, "Usage: alias <name> <command>");
            return;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        openTTY.aliases.put(string2, string3);
    }

    static void unaliasCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: unalias <alias>");
            return;
        }
        if (openTTY.aliases.containsKey(string)) {
            openTTY.aliases.remove(string);
        } else {
            OpenTTY.echoCommand$(openTTY, "unalias: ".concat(String.valueOf(string)).concat(": not found"));
        }
    }

    static void dateCommand$(OpenTTY openTTY) throws  {
        OpenTTY.echoCommand$(openTTY, ((Object)new Date()).toString());
    }

    static void echoCommand$(OpenTTY openTTY, String string) throws  {
        openTTY.output.setText(String.valueOf(openTTY.output.getText()).concat("\n").concat(String.valueOf(string)));
    }

    static void unameCommand$(OpenTTY openTTY, String string) throws  {
        openTTY.output.setText(String.valueOf(openTTY.output.getText()) + "\n" + String.valueOf(System.getProperty("microedition.platform")) + " " + String.valueOf(System.getProperty("microedition.configuration")) + " " + String.valueOf(System.getProperty("microedition.profiles")));
    }

    static void callCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: call <phone>");
            return;
        }
        try {
            openTTY.platformRequest("tel:".concat(String.valueOf(string)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void openCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: open <url>");
            return;
        }
        try {
            openTTY.platformRequest(string);
        }
        catch (Exception exception) {
            OpenTTY.echoCommand$(openTTY, "open: ".concat(String.valueOf(string)).concat(": not found"));
        }
    }

    static void lockCommand$(OpenTTY openTTY) throws  {
        if (openTTY.username == null || openTTY.username.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "lock: not logged");
        } else {
            openTTY.commandInput.setString("");
            while (!openTTY.commandInput.getString().equals(openTTY.username)) {
            }
        }
    }

    static void htopCommand$(OpenTTY openTTY) throws  {
        Runtime runtime = Runtime.getRuntime();
        OpenTTY.echoCommand$(openTTY, "Memory Status:\n\nUsed Memory: ".concat(String.valueOf((runtime.totalMemory() - runtime.freeMemory()) / (long)1024)).concat(" KB"));
        OpenTTY.echoCommand$(openTTY, "Free Memory: ".concat(String.valueOf(runtime.freeMemory() / (long)1024)).concat(" KB"));
        OpenTTY.echoCommand$(openTTY, "Total Memory: ".concat(String.valueOf(runtime.totalMemory() / (long)1024)).concat(" KB"));
    }

    static void warnCommand$(OpenTTY openTTY, String string, String string2) throws  {
        if (string2 == null || string2.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: warn <message>");
            return;
        }
        Alert alert = new Alert(string, string2, null, AlertType.WARNING);
        alert.setTimeout(-2);
        openTTY.display.setCurrent(alert, (Displayable)openTTY.form);
    }

    static void nano$(OpenTTY openTTY) throws  {
        TextBox textBox = new TextBox("Nano", openTTY.nanoContent, 9600, 0);
        Command command = new Command("Back", 4, 1);
        Command command2 = new Command("Clear", 1, 2);
        Command command3 = new Command("View as HTML", 1, 3);
        textBox.addCommand(command);
        textBox.addCommand(command2);
        textBox.addCommand(command3);
        textBox.setCommandListener((CommandListener)new OpenTTY$1(openTTY, command, command3, textBox, command2));
        openTTY.display.setCurrent((Displayable)textBox);
    }

    static void viewer$(OpenTTY openTTY, String string, String string2) throws  {
        Form form = new Form(string);
        StringItem stringItem = new StringItem(null, string2);
        Command command = new Command("Back", 4, 1);
        form.addCommand(command);
        form.append((Item)stringItem);
        form.setCommandListener((CommandListener)new OpenTTY$2(openTTY, command));
        openTTY.display.setCurrent((Displayable)form);
    }

    static void runScript$(OpenTTY openTTY, String string) throws  {
        String[] stringArray = OpenTTY.splitLines$(openTTY, string);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n].trim();
            if (!string2.startsWith("#")) {
                OpenTTY.processCommand$(openTTY, string2);
            }
            ++n;
        }
    }

    static void login$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: login <user>");
        } else if (openTTY.username.equals("")) {
            openTTY.username = string;
            OpenTTY.saveUsername$(openTTY, string);
        } else {
            OpenTTY.echoCommand$(openTTY, "login: already logged");
        }
    }

    static void saveUsername$(OpenTTY openTTY, String string) throws  {
        try {
            openTTY.userStore = RecordStore.openRecordStore((String)"OpenRMS", (boolean)true);
            byte[] byArray = string.getBytes();
            if (openTTY.userStore.getNumRecords() > 0) {
                openTTY.userStore.setRecord(1, byArray, 0, byArray.length);
            } else {
                openTTY.userStore.addRecord(byArray, 0, byArray.length);
            }
            openTTY.userStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    static void loadUsername$(OpenTTY openTTY) throws  {
        try {
            openTTY.userStore = RecordStore.openRecordStore((String)"OpenRMS", (boolean)true);
            if (openTTY.userStore.getNumRecords() > 0) {
                byte[] byArray = openTTY.userStore.getRecord(1);
                openTTY.username = new String(byArray);
            }
            openTTY.userStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            openTTY.username = "";
        }
    }

    static void deleteUsername$(OpenTTY openTTY) throws  {
        try {
            openTTY.userStore = RecordStore.openRecordStore((String)"OpenRMS", (boolean)true);
            openTTY.userStore.deleteRecord(1);
            openTTY.userStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    static void netstat$(OpenTTY openTTY) throws  {
        new Thread(new OpenTTY$3(openTTY)).start();
    }

    static void curlCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: curl <url>");
            return;
        }
        if (!string.startsWith("http://") && !string.startsWith("https://")) {
            string = "http://".concat(String.valueOf(string));
        }
        new Thread(new OpenTTY$4(openTTY, string)).start();
    }

    static void wgetCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: wget <url>");
            return;
        }
        if (!string.startsWith("http://") && !string.startsWith("https://")) {
            string = "http://".concat(String.valueOf(string));
        }
        new Thread(new OpenTTY$5(openTTY, string)).start();
    }

    static void pingCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: ping <url>");
            return;
        }
        if (!string.startsWith("http://") && !string.startsWith("https://")) {
            string = "http://".concat(String.valueOf(string));
        }
        new Thread(new OpenTTY$6(openTTY, string)).start();
    }
}

