/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class OpenTTY
extends MIDlet
implements CommandListener {
    Display display;
    Form form;
    TextField commandInput;
    StringItem output;
    Command enterCommand;
    boolean app;

    public void startApp() throws  {
        if (!this.app) {
            this.display = Display.getDisplay((MIDlet)this);
            this.form = new Form("OpenTTY 1.0");
            this.commandInput = new TextField("Command", "", 256, 0);
            this.output = new StringItem("", "Welcome to OpenTTY 1.0\nCopyright (C) 2024 - Mr. Lima\n");
            this.enterCommand = new Command("Send", 4, 1);
            this.form.append((Item)this.output);
            this.form.append((Item)this.commandInput);
            this.form.addCommand(this.enterCommand);
            this.form.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.form);
        }
    }

    public void pauseApp() throws  {
        this.app = true;
    }

    public void destroyApp(boolean bl) throws  {
    }

    public void commandAction(Command command, Displayable displayable) throws  {
        if (command == this.enterCommand) {
            String string = this.commandInput.getString();
            OpenTTY.processCommand$(this, string);
            this.commandInput.setString("");
        }
    }

    static void processCommand$(OpenTTY openTTY, String string) throws  {
        string = string.trim();
        String string2 = OpenTTY.getCommand$(openTTY, string).toLowerCase();
        String string3 = OpenTTY.getArgument$(openTTY, string);
        if (!string2.equals("")) {
            if (string2.equals("!")) {
                OpenTTY.echoCommand$(openTTY, "OpenTTY Java Edition");
            } else if (string2.equals("date")) {
                OpenTTY.dateCommand$(openTTY);
            } else if (string2.equals("exit")) {
                openTTY.notifyDestroyed();
            } else if (string2.equals("call")) {
                OpenTTY.callCommand$(openTTY, string3);
            } else if (string2.equals("echo")) {
                OpenTTY.echoCommand$(openTTY, string3);
            } else if (string2.equals("open")) {
                OpenTTY.openCommand$(openTTY, string3);
            } else if (string2.equals("uname")) {
                OpenTTY.unameCommand$(openTTY, string3);
            } else if (string2.equals("execute")) {
                OpenTTY.processCommand$(openTTY, string3);
            } else if (string2.equals("version")) {
                OpenTTY.echoCommand$(openTTY, "OpenTTY 1.0");
            } else if (string2.equals("clear") || string2.equals("cls")) {
                openTTY.output.setText("");
            } else if (string2.equals("locale")) {
                OpenTTY.echoCommand$(openTTY, System.getProperty("microedition.locale"));
            } else if (string2.equals("hostname")) {
                OpenTTY.echoCommand$(openTTY, System.getProperty("microedition.hostname"));
            } else if (string2.equals("title")) {
                if (string3.equals("")) {
                    openTTY.form.setTitle("OpenTTY 1.0");
                } else {
                    openTTY.form.setTitle(string3);
                }
            } else if (string2.equals("sh")) {
                openTTY.form.setTitle("OpenTTY 1.0");
                openTTY.output.setText("Welcome to OpenTTY 1.0\nCopyright (C) 2024 - Mr. Lima\n");
            } else if (string2.equals("help")) {
                OpenTTY.echoCommand$(openTTY, "[call] [clear] [date]\n[echo] [uname] [exit]\n[title] [version] [!]\n[execute]  [hostname]2");
            } else {
                openTTY.output.setText(String.valueOf(openTTY.output.getText()) + "\n" + String.valueOf(string2) + ": unknown command");
            }
        }
    }

    static String getCommand$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    static String getArgument$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1).trim();
    }

    static void dateCommand$(OpenTTY openTTY) throws  {
        Date date = new Date();
        String string = ((Object)date).toString();
        openTTY.output.setText(String.valueOf(openTTY.output.getText()).concat("\n").concat(String.valueOf(string)));
    }

    static void echoCommand$(OpenTTY openTTY, String string) throws  {
        openTTY.output.setText(String.valueOf(openTTY.output.getText()).concat("\n").concat(String.valueOf(string)));
    }

    static void unameCommand$(OpenTTY openTTY, String string) throws  {
        openTTY.output.setText(String.valueOf(openTTY.output.getText()) + "\n" + String.valueOf(System.getProperty("microedition.platform")) + " " + String.valueOf(System.getProperty("microedition.configuration")) + " " + String.valueOf(System.getProperty("microedition.profiles")));
    }

    static void callCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: call <phone>");
            return;
        }
        try {
            openTTY.platformRequest("tel:".concat(String.valueOf(string)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void openCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: open <url>");
            return;
        }
        try {
            openTTY.platformRequest(string);
        }
        catch (Exception exception) {
            OpenTTY.echoCommand$(openTTY, "open: ".concat(String.valueOf(string)).concat(": not found"));
        }
    }
}

