/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class ELF {
    OpenTTY midlet;
    Object stdout;
    Hashtable scope;
    String pid;
    int id = 1000;
    byte[] memory;
    int[] registers;
    int pc;
    boolean running;
    int stackPointer;
    int cpsr;
    Hashtable fileDescriptors;
    int nextFd;
    static final int EI_NIDENT = 16;
    static final int ELFCLASS32 = 1;
    static final int ELFDATA2LSB = 1;
    static final int EM_ARM = 40;
    static final int ET_EXEC = 2;
    static final int PT_LOAD = 1;
    static final int REG_R0 = 0;
    static final int REG_R1 = 1;
    static final int REG_R2 = 2;
    static final int REG_R3 = 3;
    static final int REG_R7 = 7;
    static final int REG_SP = 13;
    static final int REG_LR = 14;
    static final int REG_PC = 15;
    static final int CPSR_N = 31;
    static final int CPSR_Z = 30;
    static final int CPSR_C = 29;
    static final int CPSR_V = 28;
    static final int N_MASK = 1 << 31;
    static final int Z_MASK = 1 << 30;
    static final int C_MASK = 1 << 29;
    static final int V_MASK = 1 << 28;
    static final int COND_EQ = 0;
    static final int COND_NE = 1;
    static final int COND_CS = 2;
    static final int COND_CC = 3;
    static final int COND_MI = 4;
    static final int COND_PL = 5;
    static final int COND_VS = 6;
    static final int COND_VC = 7;
    static final int COND_HI = 8;
    static final int COND_LS = 9;
    static final int COND_GE = 10;
    static final int COND_LT = 11;
    static final int COND_GT = 12;
    static final int COND_LE = 13;
    static final int COND_AL = 14;
    static final int COND_NV = 15;
    static final int SYS_EXIT = 1;
    static final int SYS_FORK = 2;
    static final int SYS_READ = 3;
    static final int SYS_WRITE = 4;
    static final int SYS_OPEN = 5;
    static final int SYS_CLOSE = 6;
    static final int SYS_CREAT = 8;
    static final int SYS_TIME = 13;
    static final int SYS_CHDIR = 12;
    static final int SYS_GETPID = 20;
    static final int SYS_KILL = 37;
    static final int SYS_BRK = 45;
    static final int SYS_GETCWD = 183;
    static final int SYS_GETTIMEOFDAY = 78;
    static final int SYS_GETPPID = 64;
    static final int SYS_GETUID32 = 199;
    static final int SYS_GETEUID32 = 201;
    static final int O_RDONLY = 0;
    static final int O_WRONLY = 1;
    static final int O_RDWR = 2;
    static final int O_CREAT = 64;
    static final int O_APPEND = 1024;
    static final int O_TRUNC = 512;
    float[] fpuRegisters;
    int fpscr;

    public String getPid() throws  {
        return this.pid;
    }

    public void kill() throws  {
        this.running = false;
        ELF.handleExit$(this);
    }

    static String toHex$(ELF eLF, int n) throws  {
        String string = Integer.toHexString(n);
        while (string.length() < 8) {
            string = "0".concat(String.valueOf(string));
        }
        return "0x".concat(String.valueOf(string));
    }

    public boolean load(InputStream inputStream) throws Exception {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        return this.load(byteArrayOutputStream.toByteArray());
    }

    public boolean load(byte[] byArray) throws Exception {
        if (byArray.length < 4 || byArray[0] != 127 || byArray[1] != 69 || byArray[2] != 76 || byArray[3] != 70) {
            this.midlet.print("Not a valid ELF file", this.stdout);
            return false;
        }
        if (byArray[4] != 1) {
            this.midlet.print("Only 32-bit ELF supported", this.stdout);
            return false;
        }
        if (byArray[5] != 1) {
            this.midlet.print("Only little-endian ELF supported", this.stdout);
            return false;
        }
        short s = ELF.readShortLE$(this, byArray, 16);
        short s2 = ELF.readShortLE$(this, byArray, 18);
        int n = ELF.readIntLE$(this, byArray, 24);
        int n2 = ELF.readIntLE$(this, byArray, 28);
        int n3 = ELF.readShortLE$(this, byArray, 44);
        short s3 = ELF.readShortLE$(this, byArray, 42);
        if (s != 2) {
            this.midlet.print("Not an executable ELF", this.stdout);
            return false;
        }
        if (s2 != 40) {
            this.midlet.print("Not an ARM executable", this.stdout);
            return false;
        }
        this.pc = n;
        this.registers[13] = this.stackPointer;
        this.registers[14] = -1;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n2 + n4 * s3;
            int n6 = ELF.readIntLE$(this, byArray, n5);
            if (n6 == 1) {
                int n7 = ELF.readIntLE$(this, byArray, n5 + 4);
                int n8 = ELF.readIntLE$(this, byArray, n5 + 8);
                int n9 = ELF.readIntLE$(this, byArray, n5 + 16);
                int n10 = ELF.readIntLE$(this, byArray, n5 + 20);
                int n11 = 0;
                while (n11 < n9 && n11 < this.memory.length) {
                    if (n8 + n11 < this.memory.length) {
                        this.memory[n8 + n11] = byArray[n7 + n11];
                    }
                    ++n11;
                }
                n11 = n9;
                while (n11 < n10) {
                    if (n8 + n11 < this.memory.length) {
                        this.memory[n8 + n11] = 0;
                    }
                    ++n11;
                }
            }
            ++n4;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Hashtable run() throws  {
        this.running = true;
        Hashtable hashtable = this.midlet.genprocess("elf", this.id, null);
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        hashtable.put("elf", this);
        this.midlet.sys.put(this.pid, hashtable);
        try {
            try {
                while (this.running && this.pc < this.memory.length - 3 && this.midlet.sys.containsKey(this.pid)) {
                    int n = ELF.readIntLE$(this, this.memory, this.pc);
                    this.pc += 4;
                    ELF.executeInstruction$(this, n);
                }
            }
            catch (Exception exception) {
                this.midlet.print("ELF execution error: ".concat(String.valueOf(exception.toString())), this.stdout);
                this.running = false;
            }
        }
        finally {
            if (this.midlet.sys.containsKey(this.pid)) {
                this.midlet.sys.remove(this.pid);
            }
        }
        hashtable2.put("status", new Double(0.0));
        return hashtable2;
    }

    static void executeInstruction$(ELF eLF, int n) throws  {
        int n2 = n >> 28 & 0xF;
        if (!ELF.checkCondition$(eLF, n2)) {
            return;
        }
        if ((n & 0xF000000) == 0xF000000) {
            int n3 = n & 0xFFFFFF;
            if (n3 == 0) {
                ELF.handleSyscall$(eLF, eLF.registers[7]);
            } else {
                ELF.handleSyscall$(eLF, n3);
            }
            return;
        }
        if ((n & 0xFC000F0) == 144) {
            ELF.handleMultiply$(eLF, n);
            return;
        }
        if ((n & 0xF8000F0) == 0x800090) {
            ELF.handleLongMultiply$(eLF, n);
            return;
        }
        if ((n & 0xE000000) == 0x8000000) {
            ELF.handleLoadStoreMultiple$(eLF, n);
            return;
        }
        if ((n & 0xE000000) == 0xC000000) {
            ELF.handleCoprocessor$(eLF, n);
            return;
        }
        if ((n & 0xC000000) == 0) {
            ELF.handleDataProcessing$(eLF, n);
            return;
        }
        if ((n & 0xC000000) == 0x4000000) {
            ELF.handleLoadStore$(eLF, n);
            return;
        }
        if ((n & 0xE000000) == 0xA000000) {
            ELF.handleBranch$(eLF, n);
            return;
        }
        if ((n & 0xF000000) == 0x2800000 || (n & 0xF000000) == 0x2400000) {
            ELF.handleAdrSub$(eLF, n);
            return;
        }
        if (n == -509607936) {
            return;
        }
        eLF.midlet.print("[WARN] Unrecognized instruction: ".concat(String.valueOf(ELF.toHex$(eLF, n))), eLF.stdout);
    }

    static boolean checkCondition$(ELF eLF, int n) throws  {
        switch (n) {
            case 0: {
                return (eLF.cpsr & Z_MASK) != 0;
            }
            case 1: {
                return (eLF.cpsr & Z_MASK) == 0;
            }
            case 2: {
                return (eLF.cpsr & C_MASK) != 0;
            }
            case 3: {
                return (eLF.cpsr & C_MASK) == 0;
            }
            case 4: {
                return (eLF.cpsr & N_MASK) != 0;
            }
            case 5: {
                return (eLF.cpsr & N_MASK) == 0;
            }
            case 6: {
                return (eLF.cpsr & V_MASK) != 0;
            }
            case 7: {
                return (eLF.cpsr & V_MASK) == 0;
            }
            case 8: {
                return (eLF.cpsr & C_MASK) != 0 && (eLF.cpsr & Z_MASK) == 0;
            }
            case 9: {
                return (eLF.cpsr & C_MASK) == 0 || (eLF.cpsr & Z_MASK) != 0;
            }
            case 10: {
                return (eLF.cpsr & N_MASK) != 0 == ((eLF.cpsr & V_MASK) != 0);
            }
            case 11: {
                return (eLF.cpsr & N_MASK) != 0 != ((eLF.cpsr & V_MASK) != 0);
            }
            case 12: {
                return (eLF.cpsr & Z_MASK) == 0 && (eLF.cpsr & N_MASK) != 0 == ((eLF.cpsr & V_MASK) != 0);
            }
            case 13: {
                return (eLF.cpsr & Z_MASK) != 0 || (eLF.cpsr & N_MASK) != 0 != ((eLF.cpsr & V_MASK) != 0);
            }
            case 14: {
                return true;
            }
            case 15: {
                return false;
            }
        }
        return true;
    }

    static void handleMultiply$(ELF eLF, int n) throws  {
        boolean bl = (n & 1 << 21) != 0;
        boolean bl2 = (n & 1 << 20) != 0;
        int n2 = n >> 16 & 0xF;
        int n3 = n >> 12 & 0xF;
        int n4 = n >> 8 & 0xF;
        int n5 = n & 0xF;
        long l = (long)eLF.registers[n5] * (long)eLF.registers[n4];
        if (bl) {
            l += (long)eLF.registers[n3];
        }
        eLF.registers[n2] = (int)l;
        if (bl2) {
            ELF.updateFlags$(eLF, eLF.registers[n2], -1);
        }
    }

    static void handleLongMultiply$(ELF eLF, int n) throws  {
        boolean bl = (n & 1 << 22) != 0;
        boolean bl2 = (n & 1 << 21) != 0;
        boolean bl3 = (n & 1 << 20) != 0;
        int n2 = n >> 16 & 0xF;
        int n3 = n >> 12 & 0xF;
        int n4 = n >> 8 & 0xF;
        int n5 = n & 0xF;
        long l = eLF.registers[n5];
        long l2 = eLF.registers[n4];
        if (bl) {
            l = (int)l;
            l2 = (int)l2;
        } else {
            l &= 0xFFFFFFFFL;
            l2 &= 0xFFFFFFFFL;
        }
        long l3 = l * l2;
        if (bl2) {
            long l4 = (long)eLF.registers[n2] << 32 | (long)eLF.registers[n3] & 0xFFFFFFFFL;
            l3 += l4;
        }
        eLF.registers[n2] = (int)(l3 >> 32);
        eLF.registers[n3] = (int)l3;
        if (bl3) {
            boolean bl4;
            boolean bl5 = l3 >> 63 != (long)0;
            boolean bl6 = bl4 = l3 == (long)0;
            eLF.cpsr = bl5 ? (eLF.cpsr |= N_MASK) : (eLF.cpsr &= ~N_MASK);
            eLF.cpsr = bl4 ? (eLF.cpsr |= Z_MASK) : (eLF.cpsr &= ~Z_MASK);
        }
    }

    static void handleLoadStoreMultiple$(ELF eLF, int n) throws  {
        int n2;
        boolean bl = (n & 1 << 20) != 0;
        boolean bl2 = (n & 1 << 21) != 0;
        boolean bl3 = (n & 1 << 22) != 0;
        boolean bl4 = (n & 1 << 23) != 0;
        boolean bl5 = (n & 1 << 24) != 0;
        int n3 = n >> 16 & 0xF;
        int n4 = n & 0xFFFF;
        int n5 = n2 = eLF.registers[n3];
        int n6 = 0;
        int n7 = 0;
        while (n7 < 16) {
            if ((n4 & 1 << n7) != 0) {
                ++n6;
            }
            ++n7;
        }
        if (bl5) {
            n2 = bl4 ? (n2 += 4) : (n2 -= 4 * n6);
        }
        n7 = 0;
        while (n7 < 16) {
            if ((n4 & 1 << n7) != 0) {
                if (bl) {
                    if (n2 >= 0 && n2 + 3 < eLF.memory.length) {
                        eLF.registers[n7] = ELF.readIntLE$(eLF, eLF.memory, n2);
                    }
                } else if (n2 >= 0 && n2 + 3 < eLF.memory.length) {
                    ELF.writeIntLE$(eLF, eLF.memory, n2, eLF.registers[n7]);
                }
                n2 = bl4 ? (n2 += 4) : (n2 -= 4);
            }
            ++n7;
        }
        if (bl2) {
            eLF.registers[n3] = bl4 ? n5 + 4 * n6 : n5 - 4 * n6;
        }
    }

    static void handleCoprocessor$(ELF eLF, int n) throws  {
        int n2 = n >> 8 & 0xF;
        if (n2 == 10 || n2 == 11) {
            ELF.handleFPU$(eLF, n);
        } else {
            eLF.midlet.print("[WARN] Coprocessor ".concat(String.valueOf(n2)).concat(" not implemented"), eLF.stdout);
        }
    }

    static void handleFPU$(ELF eLF, int n) throws  {
        int n2 = n >> 20 & 0xF;
        int n3 = n >> 16 & 0xF;
        int n4 = n >> 12 & 0xF;
        int n5 = n >> 16 & 0xF;
        int n6 = n & 0xF;
        int n7 = n >> 8 & 0xF;
        if ((n & 0xF000000) == 0xC000000) {
            if ((n & 1 << 4) != 0) {
                ELF.handleFPURegisterTransfer$(eLF, n);
            } else {
                ELF.handleFPUDataProcessing$(eLF, n);
            }
        } else if ((n & 0xE000000) == 0xC400000) {
            ELF.handleFPULoadStore$(eLF, n);
        }
    }

    static void handleFPURegisterTransfer$(ELF eLF, int n) throws  {
        boolean bl = (n & 1 << 20) != 0;
        int n2 = n >> 12 & 0xF;
        int n3 = n >> 16 & 0xF;
        if (bl) {
            if (n3 == 1) {
                eLF.registers[n2] = eLF.fpscr;
            } else {
                int n4 = n3;
                eLF.registers[n2] = Float.floatToIntBits(eLF.fpuRegisters[n4]);
            }
        } else if (n3 == 1) {
            eLF.fpscr = eLF.registers[n2];
        } else {
            int n5 = n3;
            eLF.fpuRegisters[n5] = Float.intBitsToFloat(eLF.registers[n2]);
        }
    }

    static void handleFPUDataProcessing$(ELF eLF, int n) throws  {
        int n2 = n >> 20 & 0xFF;
        int n3 = n >> 12 & 0xF | (n & 0x10) << 1;
        int n4 = n >> 16 & 0xF | (n & 0x100000) >> 15;
        int n5 = n & 0xF;
        float f = eLF.fpuRegisters[n4];
        float f2 = eLF.fpuRegisters[n5];
        float f3 = 0.0f;
        switch (n2) {
            case 0: {
                f3 = f + f2;
                break;
            }
            case 1: {
                f3 = f - f2;
                break;
            }
            case 2: {
                f3 = f * f2;
                break;
            }
            case 3: {
                f3 = f / f2;
                break;
            }
            case 4: {
                f3 = -f;
                break;
            }
            case 5: {
                f3 = Math.abs(f);
                break;
            }
            case 6: {
                f3 = (float)Math.sqrt(f);
                break;
            }
            case 7: {
                int n6 = 0;
                n6 = Float.isNaN(f) || Float.isNaN(f2) ? (n6 |= 1) : (f == f2 ? (n6 |= 6) : (f < f2 ? (n6 |= 8) : (n6 |= 2)));
                eLF.fpscr = eLF.fpscr & ~15 | n6;
                return;
            }
            default: {
                eLF.midlet.print("[WARN] FPU opcode ".concat(String.valueOf(n2)).concat(" not implemented"), eLF.stdout);
                return;
            }
        }
        eLF.fpuRegisters[n3] = f3;
        if (Float.isNaN(f3)) {
            eLF.fpscr |= 1;
        } else if (Float.isInfinite(f3)) {
            eLF.fpscr |= 4;
        } else if (f3 == 0.0f) {
            eLF.fpscr |= 2;
        }
    }

    static void handleFPULoadStore$(ELF eLF, int n) throws  {
        boolean bl = (n & 1 << 20) != 0;
        boolean bl2 = (n & 1 << 23) != 0;
        boolean bl3 = (n & 1 << 24) != 0;
        int n2 = n >> 16 & 0xF;
        int n3 = n >> 12 & 0xF | (n & 0x10) << 1;
        int n4 = n & 0xFF;
        int n5 = eLF.registers[n2];
        if (bl3) {
            n5 = bl2 ? (n5 += 4) : (n5 -= 4);
        }
        if (bl) {
            if (n5 >= 0 && n5 + 3 < eLF.memory.length) {
                int n6 = ELF.readIntLE$(eLF, eLF.memory, n5);
                eLF.fpuRegisters[n3] = Float.intBitsToFloat(n6);
            }
        } else if (n5 >= 0 && n5 + 3 < eLF.memory.length) {
            int n7 = Float.floatToIntBits(eLF.fpuRegisters[n3]);
            ELF.writeIntLE$(eLF, eLF.memory, n5, n7);
        }
        if ((n & 1 << 21) != 0) {
            eLF.registers[n2] = bl2 ? n5 + 4 : n5 - 4;
        }
    }

    static void handleDataProcessing$(ELF eLF, int n) throws  {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n >> 21 & 0xF;
        int n9 = (n & 1 << 20) >> 20;
        int n10 = n >> 16 & 0xF;
        int n11 = n >> 12 & 0xF;
        int n12 = n7 = (eLF.cpsr & C_MASK) != 0 ? 1 : 0;
        if ((n & 1 << 25) != 0) {
            n6 = n & 0xFF;
            n5 = (n >> 8 & 0xF) * 2;
            n4 = ELF.rotateRight$(eLF, n6, n5);
            if (n5 != 0) {
                n7 = n3 = n6 >> n5 - 1 & 1;
            }
        } else {
            n6 = n & 0xF;
            n5 = n >> 5 & 3;
            if ((n & 1 << 4) == 0) {
                n3 = n >> 7 & 0x1F;
            } else {
                n2 = n >> 8 & 0xF;
                n3 = eLF.registers[n2] & 0xFF;
            }
            n2 = eLF.registers[n6];
            n4 = ELF.applyShift$(eLF, n2, n5, n3, n7);
        }
        n6 = n10 == 15 ? eLF.pc + 4 : eLF.registers[n10];
        n5 = 0;
        n3 = 0;
        n2 = (eLF.cpsr & C_MASK) != 0 ? 1 : 0;
        switch (n8) {
            case 0: {
                n5 = n6 & n4;
                n3 = 1;
                break;
            }
            case 1: {
                n5 = n6 ^ n4;
                n3 = 1;
                break;
            }
            case 2: {
                n5 = n6 - n4;
                n3 = 1;
                n7 = n6 >= n4 ? 1 : 0;
                break;
            }
            case 3: {
                n5 = n4 - n6;
                n3 = 1;
                n7 = n4 >= n6 ? 1 : 0;
                break;
            }
            case 4: {
                int n13;
                n5 = n13 = n6 + n4;
                n3 = 1;
                boolean bl = (n6 ^ n4) >= 0 && (n6 ^ n13) < 0;
                n7 = bl ? 1 : 0;
                break;
            }
            case 5: {
                int n14;
                n5 = n14 = n6 + n4 + n2;
                n3 = 1;
                long l = (long)n6 + (long)n4 + (long)n2;
                n7 = l > 0xFFFFFFFFL ? 1 : 0;
                break;
            }
            case 6: {
                int n15;
                n5 = n15 = n6 - n4 - (1 - n2);
                n3 = 1;
                n7 = n6 >= n4 + (1 - n2) ? 1 : 0;
                break;
            }
            case 7: {
                int n16;
                n5 = n16 = n4 - n6 - (1 - n2);
                n3 = 1;
                n7 = n4 >= n6 + (1 - n2) ? 1 : 0;
                break;
            }
            case 8: {
                n5 = n6 & n4;
                n9 = 1;
                n3 = 1;
                break;
            }
            case 9: {
                n5 = n6 ^ n4;
                n9 = 1;
                n3 = 1;
                break;
            }
            case 10: {
                n5 = n6 - n4;
                n9 = 1;
                n3 = 1;
                n7 = n6 >= n4 ? 1 : 0;
                break;
            }
            case 11: {
                int n17;
                n5 = n17 = n6 + n4;
                n9 = 1;
                n3 = 1;
                long l = (long)n6 + (long)n4;
                n7 = l > 0xFFFFFFFFL ? 1 : 0;
                break;
            }
            case 12: {
                n5 = n6 | n4;
                n3 = 1;
                break;
            }
            case 13: {
                n5 = n4;
                n3 = 1;
                break;
            }
            case 14: {
                n5 = n6 & ~n4;
                n3 = 1;
                break;
            }
            case 15: {
                n5 = ~n4;
                n3 = 1;
                break;
            }
        }
        if (n8 != 8 && n8 != 9 && n8 != 10 && n8 != 11) {
            eLF.registers[n11] = n5;
        }
        if (n9 != 0) {
            ELF.updateFlags$(eLF, n5, n3 != 0 ? n7 : -1);
            if (n8 == 2 || n8 == 3 || n8 == 4 || n8 == 5 || n8 == 6 || n8 == 7 || n8 == 10 || n8 == 11) {
                ELF.updateOverflow$(eLF, n6, n4, n5, n8);
            }
        }
    }

    static void handleLoadStore$(ELF eLF, int n) throws  {
        int n2 = n >> 16 & 0xF;
        int n3 = n >> 12 & 0xF;
        int n4 = n & 0xFFF;
        boolean bl = (n & 1 << 20) != 0;
        boolean bl2 = (n & 1 << 22) != 0;
        boolean bl3 = (n & 1 << 23) != 0;
        boolean bl4 = (n & 1 << 24) != 0;
        boolean bl5 = (n & 1 << 21) != 0;
        int n5 = n2 == 15 ? eLF.pc + 4 : eLF.registers[n2];
        int n6 = n5;
        if (bl4) {
            n6 = bl3 ? (n6 += n4) : (n6 -= n4);
            if (bl5 && n2 != 15) {
                eLF.registers[n2] = n6;
            }
        }
        if (bl) {
            if (n6 >= 0 && n6 < eLF.memory.length) {
                if (bl2) {
                    eLF.registers[n3] = eLF.memory[n6] & 0xFF;
                } else {
                    int n7 = n6 & ~3;
                    if (n7 + 3 < eLF.memory.length) {
                        eLF.registers[n3] = ELF.readIntLE$(eLF, eLF.memory, n7);
                    }
                }
            }
        } else if (n6 >= 0 && n6 < eLF.memory.length) {
            if (bl2) {
                eLF.memory[n6] = (byte)(eLF.registers[n3] & 0xFF);
            } else {
                ELF.writeIntLE$(eLF, eLF.memory, n6, eLF.registers[n3]);
            }
        }
        if (!bl4) {
            if (bl3) {
                int n8 = n2;
                eLF.registers[n8] = eLF.registers[n8] + n4;
            } else {
                int n9 = n2;
                eLF.registers[n9] = eLF.registers[n9] - n4;
            }
        }
    }

    static void handleBranch$(ELF eLF, int n) throws  {
        boolean bl;
        int n2 = n & 0xFFFFFF;
        if ((n2 & 0x800000) != 0) {
            n2 |= 0xFF000000;
        }
        n2 <<= 2;
        boolean bl2 = bl = (n & 1 << 24) != 0;
        if (bl) {
            eLF.registers[14] = eLF.pc;
        }
        eLF.pc = eLF.pc + n2 - 4;
    }

    static void handleAdrSub$(ELF eLF, int n) throws  {
        boolean bl = (n & 0xF000000) == 0x2800000;
        int n2 = n >> 12 & 0xF;
        int n3 = n & 0xFF;
        int n4 = (n >> 8 & 0xF) * 2;
        int n5 = ELF.rotateRight$(eLF, n3, n4);
        int n6 = eLF.pc + 4;
        eLF.registers[n2] = bl ? n6 + n5 : n6 - n5;
    }

    static int applyShift$(ELF eLF, int n, int n2, int n3, int n4) throws  {
        if (n3 == 0) {
            return n;
        }
        switch (n2) {
            case 0: {
                if (n3 >= 32) {
                    eLF.cpsr = eLF.cpsr & ~C_MASK | n << n3 - 1 >>> 31 << 29;
                    return 0;
                }
                eLF.cpsr = eLF.cpsr & ~C_MASK | n << n3 - 1 >>> 31 << 29;
                return n << n3;
            }
            case 1: {
                if (n3 >= 32) {
                    eLF.cpsr = eLF.cpsr & ~C_MASK | (n >>> n3 - 1 & 1) << 29;
                    return 0;
                }
                eLF.cpsr = eLF.cpsr & ~C_MASK | (n >>> n3 - 1 & 1) << 29;
                return n >>> n3;
            }
            case 2: {
                if (n3 >= 32) {
                    int n5 = n >>> 31;
                    eLF.cpsr = eLF.cpsr & ~C_MASK | n5 << 29;
                    return n5 == 0 ? 0 : -1;
                }
                eLF.cpsr = eLF.cpsr & ~C_MASK | (n >>> n3 - 1 & 1) << 29;
                return n >> n3;
            }
            case 3: {
                if ((n3 &= 0x1F) == 0) {
                    int n6 = n4 << 31 | n >>> 1;
                    eLF.cpsr = eLF.cpsr & ~C_MASK | (n & 1) << 29;
                    return n6;
                }
                int n7 = ELF.rotateRight$(eLF, n, n3);
                eLF.cpsr = eLF.cpsr & ~C_MASK | (n >>> n3 - 1 & 1) << 29;
                return n7;
            }
        }
        return n;
    }

    static void updateFlags$(ELF eLF, int n, int n2) throws  {
        eLF.cpsr = (n & Integer.MIN_VALUE) != 0 ? (eLF.cpsr |= N_MASK) : (eLF.cpsr &= ~N_MASK);
        eLF.cpsr = n == 0 ? (eLF.cpsr |= Z_MASK) : (eLF.cpsr &= ~Z_MASK);
        if (n2 >= 0) {
            eLF.cpsr = n2 != 0 ? (eLF.cpsr |= C_MASK) : (eLF.cpsr &= ~C_MASK);
        }
    }

    static void updateOverflow$(ELF eLF, int n, int n2, int n3, int n4) throws  {
        boolean bl = false;
        switch (n4) {
            case 2: 
            case 10: {
                bl = ((n ^ n2) & (n ^ n3) & Integer.MIN_VALUE) != 0;
                break;
            }
            case 3: {
                bl = ((n2 ^ n) & (n2 ^ n3) & Integer.MIN_VALUE) != 0;
                break;
            }
            case 4: 
            case 11: {
                bl = (~(n ^ n2) & (n ^ n3) & Integer.MIN_VALUE) != 0;
                break;
            }
        }
        eLF.cpsr = bl ? (eLF.cpsr |= V_MASK) : (eLF.cpsr &= ~V_MASK);
    }

    static void handleSyscall$(ELF eLF, int n) throws  {
        switch (n) {
            case 2: {
                ELF.handleFork$(eLF);
                break;
            }
            case 4: {
                ELF.handleWrite$(eLF);
                break;
            }
            case 3: {
                ELF.handleRead$(eLF);
                break;
            }
            case 5: {
                ELF.handleOpen$(eLF);
                break;
            }
            case 6: {
                ELF.handleClose$(eLF);
                break;
            }
            case 8: {
                ELF.handleCreat$(eLF);
                break;
            }
            case 13: {
                ELF.handleTime$(eLF);
                break;
            }
            case 12: {
                ELF.handleChdir$(eLF);
                break;
            }
            case 1: {
                ELF.handleExit$(eLF);
                break;
            }
            case 20: {
                ELF.handleGetpid$(eLF);
                break;
            }
            case 37: {
                ELF.handleKill$(eLF);
                break;
            }
            case 183: {
                ELF.handleGetcwd$(eLF);
                break;
            }
            case 45: {
                eLF.registers[0] = eLF.memory.length;
                break;
            }
            case 78: {
                ELF.handleGettimeofday$(eLF);
                break;
            }
            case 64: {
                ELF.handleGetppid$(eLF);
                break;
            }
            case 199: {
                ELF.handleGetuid$(eLF);
                break;
            }
            case 201: {
                ELF.handleGetuid$(eLF);
                break;
            }
            default: {
                eLF.registers[0] = -1;
                break;
            }
        }
    }

    static void handleFork$(ELF eLF) throws  {
        eLF.registers[0] = -1;
    }

    static void handleWrite$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        if (n3 <= 0 || n2 < 0 || n2 >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        Integer n4 = new Integer(n);
        if (n == 1 || n == 2) {
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = 0;
            while (n5 < n3 && n2 + n5 < eLF.memory.length) {
                stringBuffer.append((char)(eLF.memory[n2 + n5] & 0xFF));
                ++n5;
            }
            eLF.midlet.print(stringBuffer.toString(), eLF.stdout, eLF.id);
            eLF.registers[0] = n3;
        } else if (eLF.fileDescriptors.containsKey(n4)) {
            Object v = eLF.fileDescriptors.get(n4);
            if (v instanceof OutputStream) {
                try {
                    OutputStream outputStream = (OutputStream)v;
                    int n6 = 0;
                    while (n6 < n3 && n2 + n6 < eLF.memory.length) {
                        outputStream.write(eLF.memory[n2 + n6]);
                        ++n6;
                    }
                    outputStream.flush();
                    eLF.registers[0] = n3;
                }
                catch (Exception exception) {
                    eLF.registers[0] = -1;
                }
            } else if (v instanceof StringBuffer) {
                StringBuffer stringBuffer = (StringBuffer)v;
                int n7 = 0;
                while (n7 < n3 && n2 + n7 < eLF.memory.length) {
                    stringBuffer.append((char)(eLF.memory[n2 + n7] & 0xFF));
                    ++n7;
                }
                eLF.registers[0] = n3;
            } else {
                eLF.registers[0] = -1;
            }
        } else {
            eLF.registers[0] = -1;
        }
    }

    static void handleRead$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        if (n3 <= 0 || n2 < 0 || n2 >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        Integer n4 = new Integer(n);
        if (n == 0) {
            eLF.registers[0] = 0;
        } else if (eLF.fileDescriptors.containsKey(n4)) {
            Object v = eLF.fileDescriptors.get(n4);
            if (v instanceof InputStream) {
                try {
                    InputStream inputStream = (InputStream)v;
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < n3 && n2 + n6 < eLF.memory.length) {
                        int n7 = inputStream.read();
                        if (n7 == -1) break;
                        eLF.memory[n2 + n6] = (byte)n7;
                        ++n5;
                        ++n6;
                    }
                    eLF.registers[0] = n5;
                }
                catch (Exception exception) {
                    eLF.registers[0] = -1;
                }
            } else {
                eLF.registers[0] = -1;
            }
        } else {
            eLF.registers[0] = -1;
        }
    }

    static void handleOpen$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        if (n < 0 || n >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n + n4 < eLF.memory.length && eLF.memory[n + n4] != 0 && n4 < 256) {
            stringBuffer.append((char)(eLF.memory[n + n4] & 0xFF));
            ++n4;
        }
        String string = stringBuffer.toString();
        try {
            Object object;
            boolean bl = (n2 & 0) == 0 || (n2 & 2) == 2;
            boolean bl2 = (n2 & 1) == 1 || (n2 & 2) == 2;
            boolean bl3 = (n2 & 0x40) != 0;
            boolean bl4 = (n2 & 0x400) != 0;
            boolean bl5 = (n2 & 0x200) != 0;
            String string2 = string;
            if (!string.startsWith("/")) {
                object = (String)eLF.scope.get("PWD");
                if (object == null) {
                    object = "/home/";
                }
                string2 = String.valueOf(object).concat(String.valueOf(((String)object).endsWith("/") ? "" : "/")).concat(String.valueOf(string));
            }
            if (bl) {
                object = eLF.midlet.getInputStream(string2);
                if (object != null) {
                    Integer n5 = new Integer(eLF.nextFd++);
                    eLF.fileDescriptors.put(n5, object);
                    eLF.registers[0] = n5;
                } else if (bl3) {
                    eLF.midlet.write(string2, "", eLF.id);
                    InputStream inputStream = eLF.midlet.getInputStream(string2);
                    if (inputStream != null) {
                        Integer n6 = new Integer(eLF.nextFd++);
                        eLF.fileDescriptors.put(n6, inputStream);
                        eLF.registers[0] = n6;
                    } else {
                        eLF.registers[0] = -1;
                    }
                } else {
                    eLF.registers[0] = -2;
                }
            } else if (bl2) {
                Object object2;
                object = new ByteArrayOutputStream();
                if (bl4 && !bl5 && (object2 = eLF.midlet.getInputStream(string2)) != null) {
                    int n7;
                    while ((n7 = ((InputStream)object2).read()) != -1) {
                        ((ByteArrayOutputStream)object).write(n7);
                    }
                    ((InputStream)object2).close();
                }
                object2 = new Integer(eLF.nextFd++);
                eLF.fileDescriptors.put(object2, object);
                eLF.registers[0] = (Integer)object2;
                eLF.fileDescriptors.put(String.valueOf(object2).concat(":path"), string2);
            } else {
                eLF.registers[0] = -1;
            }
        }
        catch (Exception exception) {
            eLF.registers[0] = -1;
        }
    }

    static void handleCreat$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        eLF.registers[1] = 577;
        eLF.registers[2] = n2;
        ELF.handleOpen$(eLF);
    }

    static void handleClose$(ELF eLF) throws  {
        int n = eLF.registers[0];
        Integer n2 = new Integer(n);
        if (n == 0 || n == 1 || n == 2) {
            eLF.registers[0] = 0;
            return;
        }
        if (eLF.fileDescriptors.containsKey(n2)) {
            Object v = eLF.fileDescriptors.get(n2);
            try {
                if (v instanceof InputStream) {
                    ((InputStream)v).close();
                } else if (v instanceof OutputStream) {
                    OutputStream outputStream = (OutputStream)v;
                    outputStream.close();
                    if (v instanceof ByteArrayOutputStream) {
                        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)v;
                        String string = String.valueOf(n).concat(":path");
                        if (eLF.fileDescriptors.containsKey(string)) {
                            String string2 = (String)eLF.fileDescriptors.get(string);
                            byte[] byArray = byteArrayOutputStream.toByteArray();
                            eLF.midlet.write(string2, byArray, eLF.id);
                        }
                    }
                }
                eLF.fileDescriptors.remove(new Integer(n));
                eLF.fileDescriptors.remove(String.valueOf(n).concat(":path"));
                eLF.registers[0] = 0;
            }
            catch (Exception exception) {
                eLF.registers[0] = -1;
            }
        } else {
            eLF.registers[0] = -1;
        }
    }

    static void handleTime$(ELF eLF) throws  {
        long l = System.currentTimeMillis() / (long)1000;
        eLF.registers[0] = (int)l;
        int n = eLF.registers[1];
        if (n != 0 && n >= 0 && n + 3 < eLF.memory.length) {
            ELF.writeIntLE$(eLF, eLF.memory, n, (int)l);
        }
    }

    static void handleChdir$(ELF eLF) throws  {
        int n = eLF.registers[0];
        if (n < 0 || n >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n + n2 < eLF.memory.length && eLF.memory[n + n2] != 0 && n2 < 256) {
            stringBuffer.append((char)(eLF.memory[n + n2] & 0xFF));
            ++n2;
        }
        String string = stringBuffer.toString();
        if (string.equals("") || string.equals(".")) {
            eLF.registers[0] = 0;
            return;
        }
        String string2 = string;
        if (!string.startsWith("/")) {
            String string3 = (String)eLF.scope.get("PWD");
            if (string3 == null) {
                string3 = "/home/";
            }
            string2 = String.valueOf(string3).concat(String.valueOf(string3.endsWith("/") ? "" : "/")).concat(String.valueOf(string));
        }
        if (!string2.endsWith("/")) {
            string2 = String.valueOf(string2).concat("/");
        }
        boolean bl = false;
        if (string2.equals("/home/")) {
            bl = true;
        } else if (string2.startsWith("/mnt/")) {
            try {
                FileConnection fileConnection = (FileConnection)Connector.open((String)"file:///".concat(String.valueOf(string2.substring(5))), (int)1);
                bl = fileConnection.exists() && fileConnection.isDirectory();
                fileConnection.close();
            }
            catch (Exception exception) {
                bl = false;
            }
        } else if (eLF.midlet.fs.containsKey(string2)) {
            bl = true;
        }
        if (bl) {
            eLF.scope.put("PWD", string2);
            eLF.registers[0] = 0;
        } else {
            eLF.registers[0] = -2;
        }
    }

    static void handleGetpid$(ELF eLF) throws  {
        try {
            int n;
            eLF.registers[0] = n = Integer.parseInt(eLF.pid);
        }
        catch (NumberFormatException numberFormatException) {
            eLF.registers[0] = 1;
        }
    }

    static void handleKill$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        String string = String.valueOf(n);
        if (!eLF.midlet.sys.containsKey(string)) {
            eLF.registers[0] = -3;
            return;
        }
        if (eLF.id != 0 && !string.equals(eLF.pid)) {
            eLF.registers[0] = -1;
            return;
        }
        if (n2 == 9) {
            Hashtable hashtable;
            Object v = eLF.midlet.sys.get(string);
            if (v instanceof Hashtable && (hashtable = (Hashtable)v).containsKey("elf")) {
                ELF eLF2 = (ELF)hashtable.get("elf");
                eLF2.kill();
            }
            eLF.midlet.sys.remove(string);
            eLF.registers[0] = 0;
        } else if (n2 == 15) {
            eLF.midlet.sys.remove(string);
            eLF.registers[0] = 0;
        } else {
            eLF.registers[0] = -22;
        }
    }

    static void handleExit$(ELF eLF) throws  {
        int n = eLF.registers[0];
        eLF.running = false;
        Enumeration enumeration = eLF.fileDescriptors.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2;
            Object k = enumeration.nextElement();
            if (!(k instanceof Integer) || (n2 = (Integer)k) < 3) continue;
            Object v = eLF.fileDescriptors.get(n2);
            try {
                if (v instanceof InputStream) {
                    ((InputStream)v).close();
                    continue;
                }
                if (!(v instanceof OutputStream)) continue;
                ((OutputStream)v).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void handleGetcwd$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        String string = (String)eLF.scope.get("PWD");
        if (string == null) {
            string = "/home/";
        }
        byte[] byArray = string.getBytes();
        int n3 = Math.min(byArray.length, n2 - 1);
        int n4 = 0;
        while (n4 < n3 && n + n4 < eLF.memory.length) {
            eLF.memory[n + n4] = byArray[n4];
            ++n4;
        }
        if (n + n3 < eLF.memory.length) {
            eLF.memory[n + n3] = 0;
        }
        eLF.registers[0] = n;
    }

    static void handleGettimeofday$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        long l = System.currentTimeMillis();
        int n3 = (int)(l / (long)1000);
        int n4 = (int)(l % (long)1000 * (long)1000);
        if (n != 0 && n >= 0 && n + 7 < eLF.memory.length) {
            ELF.writeIntLE$(eLF, eLF.memory, n, n3);
            ELF.writeIntLE$(eLF, eLF.memory, n + 4, n4);
        }
        eLF.registers[0] = 0;
    }

    static void handleGetppid$(ELF eLF) throws  {
        eLF.registers[0] = 1;
    }

    static void handleGetuid$(ELF eLF) throws  {
        eLF.registers[0] = eLF.id;
    }

    static void handleGetgid$(ELF eLF) throws  {
        eLF.registers[0] = 1000;
    }

    static int readIntLE$(ELF eLF, byte[] byArray, int n) throws  {
        if (n + 3 >= byArray.length || n < 0) {
            return 0;
        }
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    static short readShortLE$(ELF eLF, byte[] byArray, int n) throws  {
        if (n + 1 >= byArray.length || n < 0) {
            return 0;
        }
        return (short)(byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8);
    }

    static void writeIntLE$(ELF eLF, byte[] byArray, int n, int n2) throws  {
        if (n + 3 >= byArray.length || n < 0) {
            return;
        }
        byArray[n] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 3] = (byte)(n2 >> 24 & 0xFF);
    }

    static int rotateRight$(ELF eLF, int n, int n2) throws  {
        return n >>> (n2 &= 0x1F) | n << 32 - n2;
    }

    public ELF(OpenTTY openTTY, Object object, Hashtable hashtable, int n, String string, Hashtable hashtable2) throws  {
        this.midlet = openTTY;
        this.stdout = object;
        this.scope = hashtable;
        this.id = n;
        this.pid = string == null ? openTTY.genpid() : string;
        this.memory = new byte[0x100000];
        this.registers = new int[16];
        this.fpuRegisters = new float[32];
        this.cpsr = 0;
        this.fpscr = 0;
        this.running = false;
        this.stackPointer = this.memory.length - 1024;
        this.fileDescriptors = new Hashtable();
        this.nextFd = 3;
        this.fileDescriptors.put(new Integer(1), object);
        this.fileDescriptors.put(new Integer(2), object);
    }
}

